<?php
// Webhook endpoint para receber notificações da PayFort
// Este arquivo deve ser acessível publicamente para receber os webhooks

header('Content-Type: application/json');

// Log da requisição (para debug)
$logFile = __DIR__ . '/webhook_log.txt';
$logData = [
    'timestamp' => date('Y-m-d H:i:s'),
    'method' => $_SERVER['REQUEST_METHOD'],
    'headers' => getallheaders(),
    'body' => file_get_contents('php://input')
];
file_put_contents($logFile, json_encode($logData) . "\n", FILE_APPEND);

// Obter dados do webhook
$webhookData = json_decode(file_get_contents('php://input'), true);

if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid JSON']);
    exit;
}

// Verificar estrutura do webhook PayFort
// Baseado na documentação: https://docs.payfortbr.com/docs/Webhooks
if (!isset($webhookData['transactionId']) || !isset($webhookData['status'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid webhook data']);
    exit;
}

$transactionId = $webhookData['transactionId'];
$status = $webhookData['status'];
$object = $webhookData['object'] ?? 'cashin';

// Processar diferentes status
switch ($status) {
    case 'paid':
        // Pagamento confirmado
        // Aqui você deve:
        // 1. Salvar no banco de dados que o pagamento foi confirmado
        // 2. Atualizar status da transação
        // 3. Enviar notificação ao usuário (se necessário)
        error_log("Payment confirmed: Transaction {$transactionId}");
        break;
    
    case 'refund':
        // Reembolso realizado
        error_log("Payment refunded: Transaction {$transactionId}");
        break;
    
    case 'infraction':
        // Infração detectada
        error_log("Payment infraction: Transaction {$transactionId}");
        break;
    
    case 'created':
        // Transação criada (geralmente já temos essa info)
        error_log("Payment created: Transaction {$transactionId}");
        break;
    
    default:
        error_log("Unknown status: {$status} for Transaction {$transactionId}");
}

// Retornar sucesso para PayFort
http_response_code(200);
echo json_encode([
    'received' => true,
    'transactionId' => $transactionId,
    'status' => $status
]);
?>

